/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.network;

import java.util.function.Supplier;
import mob_grinding_utils.tile.TileEntityAbsorptionHopper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;

public class MessageAbsorptionHopper {
    public ResourceKey<Level> dimension;
    public int entityID;
    public int buttonID;
    public BlockPos tilePos;

    public MessageAbsorptionHopper(Player player, int button, BlockPos pos) {
        this.dimension = player.m_20193_().m_46472_();
        this.entityID = player.m_142049_();
        this.buttonID = button;
        this.tilePos = pos;
    }

    public MessageAbsorptionHopper(Player player, int button, int x, int y, int z) {
        this.dimension = player.m_20193_().m_46472_();
        this.entityID = player.m_142049_();
        this.buttonID = button;
        this.tilePos = new BlockPos(x, y, z);
    }

    public MessageAbsorptionHopper(ResourceLocation dimensionKey, int entityID, int buttonID, BlockPos tilePos) {
        this.dimension = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)dimensionKey);
        this.entityID = entityID;
        this.buttonID = buttonID;
        this.tilePos = tilePos;
    }

    public static void encode(MessageAbsorptionHopper message, FriendlyByteBuf buf) {
        buf.m_130085_(message.dimension.m_135782_());
        buf.writeInt(message.entityID);
        buf.writeInt(message.buttonID);
        buf.m_130064_(message.tilePos);
    }

    public static MessageAbsorptionHopper decode(FriendlyByteBuf buf) {
        return new MessageAbsorptionHopper(buf.m_130281_(), buf.readInt(), buf.readInt(), buf.m_130135_());
    }

    public static void handle(MessageAbsorptionHopper message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            TileEntityAbsorptionHopper hopper;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            ServerLevel world = player.m_20194_().m_129880_(message.dimension);
            if (world != null && !world.f_46443_ && player.m_142049_() == message.entityID && (hopper = (TileEntityAbsorptionHopper)world.m_7702_(message.tilePos)) != null) {
                if (message.buttonID < 6) {
                    hopper.toggleMode(Direction.m_122376_((int)message.buttonID));
                }
                if (message.buttonID == 6) {
                    hopper.toggleRenderBox();
                }
                if (message.buttonID > 6 && message.buttonID <= 12) {
                    hopper.toggleOffset(message.buttonID);
                }
                BlockState state = world.m_8055_(message.tilePos);
                world.m_7260_(message.tilePos, state, state, 3);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

